<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DiscoveryEngine;

class GoogleCloudDiscoveryengineV1alphaAssistantContent extends \Google\Model
{
  protected $codeExecutionResultType = GoogleCloudDiscoveryengineV1alphaAssistantContentCodeExecutionResult::class;
  protected $codeExecutionResultDataType = '';
  protected $executableCodeType = GoogleCloudDiscoveryengineV1alphaAssistantContentExecutableCode::class;
  protected $executableCodeDataType = '';
  protected $fileType = GoogleCloudDiscoveryengineV1alphaAssistantContentFile::class;
  protected $fileDataType = '';
  protected $inlineDataType = GoogleCloudDiscoveryengineV1alphaAssistantContentBlob::class;
  protected $inlineDataDataType = '';
  /**
   * The producer of the content. Can be "model" or "user".
   *
   * @var string
   */
  public $role;
  /**
   * Inline text.
   *
   * @var string
   */
  public $text;
  /**
   * Optional. Indicates if the part is thought from the model.
   *
   * @var bool
   */
  public $thought;

  /**
   * Result of executing an ExecutableCode.
   *
   * @param GoogleCloudDiscoveryengineV1alphaAssistantContentCodeExecutionResult $codeExecutionResult
   */
  public function setCodeExecutionResult(GoogleCloudDiscoveryengineV1alphaAssistantContentCodeExecutionResult $codeExecutionResult)
  {
    $this->codeExecutionResult = $codeExecutionResult;
  }
  /**
   * @return GoogleCloudDiscoveryengineV1alphaAssistantContentCodeExecutionResult
   */
  public function getCodeExecutionResult()
  {
    return $this->codeExecutionResult;
  }
  /**
   * Code generated by the model that is meant to be executed.
   *
   * @param GoogleCloudDiscoveryengineV1alphaAssistantContentExecutableCode $executableCode
   */
  public function setExecutableCode(GoogleCloudDiscoveryengineV1alphaAssistantContentExecutableCode $executableCode)
  {
    $this->executableCode = $executableCode;
  }
  /**
   * @return GoogleCloudDiscoveryengineV1alphaAssistantContentExecutableCode
   */
  public function getExecutableCode()
  {
    return $this->executableCode;
  }
  /**
   * A file, e.g., an audio summary.
   *
   * @param GoogleCloudDiscoveryengineV1alphaAssistantContentFile $file
   */
  public function setFile(GoogleCloudDiscoveryengineV1alphaAssistantContentFile $file)
  {
    $this->file = $file;
  }
  /**
   * @return GoogleCloudDiscoveryengineV1alphaAssistantContentFile
   */
  public function getFile()
  {
    return $this->file;
  }
  /**
   * Inline binary data.
   *
   * @param GoogleCloudDiscoveryengineV1alphaAssistantContentBlob $inlineData
   */
  public function setInlineData(GoogleCloudDiscoveryengineV1alphaAssistantContentBlob $inlineData)
  {
    $this->inlineData = $inlineData;
  }
  /**
   * @return GoogleCloudDiscoveryengineV1alphaAssistantContentBlob
   */
  public function getInlineData()
  {
    return $this->inlineData;
  }
  /**
   * The producer of the content. Can be "model" or "user".
   *
   * @param string $role
   */
  public function setRole($role)
  {
    $this->role = $role;
  }
  /**
   * @return string
   */
  public function getRole()
  {
    return $this->role;
  }
  /**
   * Inline text.
   *
   * @param string $text
   */
  public function setText($text)
  {
    $this->text = $text;
  }
  /**
   * @return string
   */
  public function getText()
  {
    return $this->text;
  }
  /**
   * Optional. Indicates if the part is thought from the model.
   *
   * @param bool $thought
   */
  public function setThought($thought)
  {
    $this->thought = $thought;
  }
  /**
   * @return bool
   */
  public function getThought()
  {
    return $this->thought;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDiscoveryengineV1alphaAssistantContent::class, 'Google_Service_DiscoveryEngine_GoogleCloudDiscoveryengineV1alphaAssistantContent');
